<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class District extends Model 
{

    protected $table = 'districts';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('city_id', 'name');
    protected $visible = array('city_id', 'name');

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function offzones()
    {
        return $this->hasMany('App\Models\OffZone');
    }

    public function orderLocations()
    {
        return $this->hasMany('App\Models\Order\Location');
    }

    public function warehouses()
    {
        return $this->hasMany('App\Models\Company\Warehouse');
    }

}